using inetsoftware.Pdfc;
using inetsoftware.Pdfc.Results;
using System;
using System.Collections.Generic;

namespace inetsoftware.PdfcSamples
{
    /// <summary>
    /// A sample to show how to get informations of a difference.
    /// Expects 2 arguments - the paths of the PDF files
    /// </summary>
    public class MessageOfDifferences
    {
        static MessageOfDifferences()
        {
            // Activate the license once from environment if required.
            string key = Environment.GetEnvironmentVariable("PDFC_KEY");
            if (!string.IsNullOrEmpty(key))
            {
                PDFC.ActivateLicense(key);
            }
        }

        /// <summary>
        /// Start the sample, that show the message/text of each difference.
        /// </summary>
        /// <param name="args">Expected 2 arguments, the path of the PDF files</param>
        public static void Main(string[] args) {
            if (args == null || args.Length != 2)
            {
                throw new ArgumentException("Usage: <executable> <PDF-File1> <PDF-File2>");
            }

            PDFComparer pdfComparer = new PDFComparer();

            using (ResultModel result = pdfComparer.Compare(args[0], args[1]))
            {
                List<Diff> differences = result.GetDifferences(false);
                foreach(Diff diff in differences)
                {
                    System.Console.WriteLine("Message = " + diff.Message);
                }
            }
        }
    }

}